#!/sbin/sh

# Get $ROM_NAME from ROM_NAME.prop
ROM_NAME=`cat '/tmp/aroma/ROM_NAME.prop' | sed 's/ROM_NAME=//g'`

# Mount the SD-EXT partition
# Done by SD-EXT_mounter.sh
STATUS=`cat '/tmp/mount.prop' | sed 's/status=//g'`
if [ "$STATUS" = "mounted" ]; then

	mkdir -p /NativeSD/$ROM_NAME/system
	mkdir -p /NativeSD/$ROM_NAME/data

	mount --bind /NativeSD/$ROM_NAME/system /system
	mount --bind /NativeSD/$ROM_NAME/data   /data
	
	mkdir -p /sdcard/NativeSD/$ROM_NAME
	mkdir -p /boot
	mkdir -p /boot_dir

	mount --bind /sdcard/NativeSD/$ROM_NAME /boot
	mount --bind /sdcard/NativeSD           /boot_dir

	# delete the old system
	rm -rf /system/*

	echo "NativeSD=true" >> /tmp/nfo.prop

else

	# no SD-EXT partition found	
	echo "NativeSD=false" >> /tmp/nfo.prop

fi
